@extends('layouts.master')

@section('title')
    Detail Anggota
@endsection

@section('breadcrumb')
    @parent
    <li class="active">Detail Anggota</li>
@endsection

@section('content')
<form action="{{ route('member.updated_detail', $member->id) }}" class="form" id="forms" style="width:100%;" method="post">
    @csrf
    @method('PUT')
<div class="row">
    <div class="col-lg-12">
        <div class="box">
            {{-- <button onclick="window.print()">Print this page</button> --}}
            <div class="box-header with-border">
                <h4>PROFIL ANGGOTA</h4>
            </div>
            <div class="box-body table-responsive">
                <table class="table table-stiped table-bordered table-penjualan">
                    <thead>
                        <th>Nama Lengkap</th>
                        <th>Tempat Tanggal Lahir</th>
                        <th>Alamat Rumah</th>
                        <th>Telepon</th>
                        <th>Telepon Darurat</th>
                        <th>Foto</th>
                        {{-- <th>Tanggal Masuk</th> --}}

                        
                    </thead>
                    <tbody>
                        <td>{{$member->nama}}</td>
                        <td>{{$member->ttl}}</td>
                        <td>{{$member->alamat}}</td>
                        <td>{{$member->telepon}}</td>
                        <td>{{$member->telepon_darurat}}</td>
                        <td><button type="button" class="btn btn-primary" data-toggle="modal" data-target="#exampleModal">
                            Foto
                            </button></td>
                        {{-- <td>{{$member->tgl_masuk}}</td> --}}
                    </tbody>
                    <thead>
                        <th>Nomer KTP</th>
                        <th>Jenis Kelamin</th>
                        <th>Alamat Kantor</th>
                        <th>Email</th>
                        <th>Sosmed</th>
                        {{-- <th>Tanggal Berakhir</th> --}}
                    </thead>
                    <tbody>
                        <td>{{$member->no_ktp}}</td>
                        <td>{{$member->gender}}</td>
                        <td>{{$member->alamat_kantor}}</td>
                        <td>{{$member->email}}</td>
                        <td>{{$member->sosmed}}</td>
                        {{-- <td>{{$member->exp_date}}</td> --}}
                    </tbody>
                </table>
                
            </div>
        </div>
    </div>
</div>



<div class="row">
    <div class="col-lg-12">
        <div class="box">
            <div class="box-header with-border">
                <h4>DETAIL MEMBERSHIP</h4>
            </div>
            <div class="box-body table-responsive">
                <table class="table table-stiped table-bordered table-penjualan">
                    <thead>
                        <th>Nama Paket Membership</th>
                        <th>Harga Paket</th>    
                        <th>Biaya Lainnya</th>
                        <th>Biaya Admin</th>    
                        <th>Total</th>    
                    </thead>
                    <tbody>
                        <td>{{$member->id_paket}}</td>
                        <td>@currency($member->harga)</td>
                        <td>@currency($member->membership_biaya_lainnya)</td>
                        <td>@currency($member->membership_biaya_admin)</td>
                        <td>@currency($member->membership_total)</td>
                    </tbody>
                    <thead>
                         <th>Tanggal Masuk</th>
                        <th>Tanggal Berakhir</th>
                        <th>Jenis Pembayaran</th>
                        <th>Nama Konsultan</th>
                        
                    </thead>
                    <tbody>
                        <td>{{$member->tgl_masuk_membership}}</td>
                        <td>{{$member->tgl_exp_membership}}</td>
                        <td>{{$member->jenis_bayar_membership}}</td>
                        <td>{{$member->nama_konsultan}}</td>
                        
                    </tbody>
                </table>
                
            </div>
        </div>
    </div>
</div>




<div class="row">
    <div class="col-lg-12">
        <div class="box">
            <div class="box-header with-border">
                <h4>DETAIL PERSONAL TRAINER</h4>
            </div>
            <div class="box-body table-responsive">
                <table class="table table-stiped table-bordered table-penjualan">
                    <thead>
                       <th>Nama Paket</th>
                       <th>Harga</th>
                       <th>Biaya Lainnya</th>
                       <th>Biaya Admin</th>
                       <th>Total</th>
                      
                    </thead>
                    <tbody>
                        <td>{{$member->paket_pt}}</td>
                        <td>@currency($member->harga_pt)</td>
                        <td>@currency($member->pt_biaya_lainnya)</td>
                        <td>@currency($member->pt_biaya_admin)</td>
                        <td>@currency($member->pt_total)</td>
                        
                    </tbody>
                    <thead>
                        <th>Tanggal Masuk</th>
                        <th>Tanggal Berakhir</th> 
                        <th>Jenis Pembayaran</th>
                        <th>Nama Personal Trainer</th>
                      
                    </thead>
                    <tbody>  
                        <td>{{$member->tgl_masuk_pt}}</td>
                         <td>{{$member->tgl_exp_pt}}</td>
                         <td>{{$member->jenis_bayar_pt}}</td>
                         <td>{{$member->nama_personal}}</td>
                         
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>






</form>
@includeIf('member.form')
@endsection
 
  
  
 
