@extends('layouts.master')

@section('title')
Data Absen 
@endsection

@section('breadcrumb')
    @parent
    <li class="active">Check in Member</li>
@endsection

@section('content')
<div class="row">
        <div class="col-lg-12">
            <div class="box">
                <div class="box-body table-responsive">
                    <form action="" method="post" class="form-member">
                        @csrf
                        <table class="table table-stiped table-bordered table-penjualan" id="table1">
                            <thead>
                                <th width="5%">No</th>  
                                <th>Kode Member</th>      
                                <th>Nama</th>      
                                <th>Status Membership</th>      
                                <th>Status Personal</th>      
                                <th>Tanggal</th>      
                                <th>Jam</th>      
                            </thead>
                            <tbody>
                                @foreach ($member as $key => $item)
                                    <tr>
                                        <td width="5%">{{ $key+1 }}</td>
                                        <td>{{$item->kode_member}}</td>
                                        <td>{{$item->nama}}</td>
                                        <td>{{$item->status}}</td>
                                        <td>{{$item->status2}}</td>
                                        <td>{{$item->tanggal}}</td>
                                        <td>{{$item->jam}}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </form>
                </div>
            </div>
        </div>
    </div>


@endsection
@push('scripts')
<script>
     $(function () {

        $('#modal-form').validator().on('submit', function (e) {
            if (! e.preventDefault()) {
                $.post($('#modal-form form').attr('action'), $('#modal-form form').serialize())
                    .done((response) => {
                        $('#modal-form').modal('hide');
                        table1.ajax.reload();
                    })
                    .fail((errors) => {
                        alert('Tidak dapat menyimpan data');
                        return;
                    });
            }
        });
       

        $('[name=select_all]').on('click', function () {
            $(':checkbox').prop('checked', this.checked);
        });
    });
</script>

@endpush