<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Personal;
use App\Models\Checkinpt;
use App\Models\Checkout_pt;
use Carbon\Carbon;
use DB;
use Redirect,Response;
class PersonalController extends Controller
{
     /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        // $kategori = Kategori::all()->pluck('nama_kategori', 'id_kategori');

        return view('personal.index');
    }

    public function data()
    {
        $personal = Personal::all();   

        return datatables()
            ->of($personal)
            ->addIndexColumn()
            ->addColumn('select_all', function ($personal) {
                return '
                    <input type="checkbox" name="id_personal[]" value="'. $personal->id_personal .'">
                ';
            })
            ->addColumn('kode_personal', function ($personal) {
                return '<span class="label label-primary">'. $personal->kode_personal.'</span>';
            })
           
            ->addColumn('aksi', function ($personal) {
                return '
                <div class="btn-group">
                <a href="'. route('personal.afiliansi', $personal->id_personal) .'" class="btn btn-xs btn-info btn-flat"><i class="fas fa-users"></i></a>
                    <button type="button" onclick="editForm(`'. route('personal.update', $personal->id_personal) .'`)" class="btn btn-xs btn-info btn-flat"><i class="fas fa-pencil-alt"></i></button>
                    <button type="button" onclick="deleteData(`'. route('personal.destroy', $personal->id_personal) .'`)" class="btn btn-xs btn-danger btn-flat"><i class="fa fa-trash"></i></button>
                </div>
                ';
            })
            ->rawColumns(['aksi', 'kode_personal', 'select_all'])
            ->make(true);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
    
        $paket = Personal::latest()->first() ?? new Personal();
        $request['kode_personal'] = 'PSL'. tambah_nol_didepan((int)$paket->id_personal +1,);

        $personal = Personal::create($request->all());

        return response()->json('Data berhasil disimpan', 200);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $personal = Personal::find($id);

        return response()->json($personal);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $personal = Personal::find($id);
        $personal->update($request->all());

        return response()->json('Data berhasil disimpan', 200);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $personal = Personal::find($id);
        $personal->delete();

        return response(null, 204);
    }
    public function afiliansi($id)
    {
        // $konsultan = Konsultan::find($id);
        $afiliansi = DB::table('personal_trainer')
        ->leftjoin('pt', 'pt.id_personal', '=', 'personal_trainer.id_personal')
        ->leftjoin('data_member', 'pt.id_member', '=', 'data_member.id')
         ->select('pt.*','personal_trainer.nama_personal','personal_trainer.id_personal','data_member.nama as nama_personal','pt.tgl_masuk as tanggal_personal')
         ->where('pt.id_personal',$id)
         ->get();
        //  dd($afiliansi);
        return view('personal.afiliansi',compact('afiliansi'));
    }
   

  
}
