<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Marketing;
class MarketingController extends Controller
{
    public function index()
    {
        return view('marketing.index');
    }

    public function data()
    {
        $marketing = Marketing::orderBy('id', 'desc')->get();

        return datatables()
            ->of($marketing)
            ->addIndexColumn()
            ->addColumn('aksi', function ($marketing) {
                return '
                <div class="btn-group">
                    <button type="button" onclick="editForm(`'. route('marketing.update', $marketing->id) .'`)" class="btn btn-xs btn-info btn-flat"><i class="fa fa-pencil"></i></button>
                    <button type="button" onclick="deleteData(`'. route('marketing.destroy', $marketing->id) .'`)" class="btn btn-xs btn-danger btn-flat"><i class="fa fa-trash"></i></button>
                </div>
                ';
            })
            ->rawColumns(['aksi'])
            ->make(true);
    }

    public function store(Request $request)
    {
        $marketing = Marketing::create($request->all());
// KODE OTOMATIS TAMBAHKAN SYNTAX DISINI
        return response()->json('Data berhasil disimpan', 200);
    }

    public function update(Request $request, $id)
    {
        $marketing = Marketing::find($id);
        $marketing->update($request->all());

        return response()->json('Data berhasil disimpan', 200);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $marketing = Marketing::find($id);
        $marketing->delete();

        return response(null, 204);
    }

    public function show($id)
    {
        $marketing = Marketing::find($id);

        return response()->json($marketing);
    }
}
