<?php

namespace App\Http\Controllers;

use App\Models\Pembelian;
use App\Models\Pengeluaran;
use App\Models\Penjualan;
use App\Models\TotalKeseluruhan;
use App\Models\PembelianGym;
use App\Models\PenjualanDetail;
use App\Models\Target;
use Illuminate\Http\Request;
use PDF;
use DB;
use Carbon\Carbon;
use DivisionByZeroError;

class LaporanController extends Controller
{
    public function index(Request $request)
    {
        // $d=date('m-y');
        $tanggalAwal = date('Y-m-d', mktime(0, 0, 0, date('m'), 1, date('Y')));
        $tanggalAkhir = date('Y-m-d');

        if ($request->has('tanggal_awal') && $request->tanggal_awal != "" && $request->has('tanggal_akhir') && $request->tanggal_akhir) {
            $tanggalAwal = $request->tanggal_awal;
            $tanggalAkhir = $request->tanggal_akhir;
        }
        // $target_bulan_ini = Target::sum('target_bulan');
        // $total_penjualan = Penjualan::where('created_at', 'LIKE', "%$carbon%")->sum('total_harga');
        // $total_member = TotalKeseluruhan::where('created_at', 'LIKE', "%$carbon%")->whereNotIn('status',['PENJUALAN'])->sum('total');
        // $total_pengeluaran = PembelianGym::where('created_at', 'LIKE', "%$carbon%")->sum('total');
        // $total_penjualan_bulan = $total_penjualan + $total_member;
    //    dd($target_bulan_ini);
        
        return view('laporan.index', compact('tanggalAwal', 'tanggalAkhir'));
    }

    public function getData($awal, $akhir)
    {
        // $d = date('m');
        // $target_awal = Target::where('created_at',$d)->sum('target_bulan');
        // dd($target_awal);
        $no = 1;
        $data = array();
        $pendapatan = 0;
        $total_pendapatan = 0;
        $total_bulan = 0;
        $total_pengeluaran_bulan = 0;
        $target = 0;
        $persen = 0;
        $carbon =  Carbon::now()->format('Y-m');
        while (strtotime($awal) <= strtotime($akhir)) {
            $tanggal = $awal;
            $tanggal_hari_ini = date('Y-m');
            $awal = date('Y-m-d', strtotime("+1 day", strtotime($awal)));

            $total_penjualan = Penjualan::where('created_at', 'LIKE', "%$tanggal%")->sum('total_harga');
            $total_member = TotalKeseluruhan::where('created_at', 'LIKE', "%$tanggal%")->whereNotIn('status',['PENJUALAN'])->sum('total');
            $total_pengeluaran = PembelianGym::where('created_at', 'LIKE', "%$tanggal%")->sum('total');
            $target_bulan_ini = Target::where('created_at', 'LIKE', "%$tanggal%")->sum('target_bulan');
            
            $total_penjualan_karo_member = $total_penjualan + $total_member;
            // dd($total_penjualan_karo_member);
            $pendapatan =  $total_penjualan_karo_member - $total_pengeluaran;
            $total_pendapatan += $pendapatan;
            
            $total_bulan += $total_penjualan_karo_member;
            $total_pengeluaran_bulan += $total_pengeluaran;
            $target += $target_bulan_ini;  
          


            $row = array();
            $row['DT_RowIndex'] = $no++;
            $row['tanggal'] = tanggal_indonesia($tanggal, false);
            $row['penjualan'] = format_uang($total_penjualan_karo_member);
            $row['pembelian'] = format_uang($total_pengeluaran);
            $row['pendapatan'] = format_uang($pendapatan);
            // $row['total'] = format_uang($target);
            
            $data[] = $row;
        }
        if ($total_pendapatan > 0) {
            $data[] = [
            
                'DT_RowIndex' => 'Persentase saat ini : ' . ($total_pendapatan  / $target)*100 . '%',
                'tanggal' => 'Target Bulan ini : ' . format_uang($target),
                'penjualan' => format_uang($total_bulan),
                'pembelian' => format_uang($total_pengeluaran_bulan),
                'pendapatan' => format_uang($total_pendapatan),
                'total' => format_uang($total_pendapatan),
               
            ];

          
            
        } elseif($total_pendapatan ==  0) {
            $data[] = [
            
                'DT_RowIndex' => 'Persentase saat ini : 0 %',
                'tanggal' => 'Target Bulan ini : ' . format_uang($target),
                'penjualan' => format_uang($total_bulan),
                'pembelian' => format_uang($total_pengeluaran_bulan),
                'pendapatan' => format_uang($total_pendapatan),
                'total' => format_uang($total_pendapatan),
               
            ];
        }
        
        
       
         return $data;
    }
    public function detail_pendapatan()
    {
          $pendaftaran = DB::table('member')
            ->join('total_keseluruhan', 'total_keseluruhan.id_member', '=', 'member.id_member')
            ->select('total_keseluruhan.*','nama', 'total_keseluruhan.total','member.role')
            ->where('total_keseluruhan.created_at', '>=', Carbon::today())
            // ->where('total_keseluruhan.role',$auth)
            ->get();
        return view('laporan.detail_pendapatan',compact('pendaftaran'));
    }
    public function data($awal, $akhir)
    {
     
        $data = $this->getData($awal, $akhir);
        
        return datatables()
            ->of($data)
            ->make(true);
    }
    

    public function exportPDF($awal, $akhir)
    {
        $data = $this->getData($awal, $akhir);
        $pdf  = PDF::loadView('laporan.pdf', compact('awal', 'akhir', 'data'));
        $pdf->setPaper('a4', 'potrait');
        
        return $pdf->stream('Laporan-pendapatan-'. date('Y-m-d-his') .'.pdf');
    }
}
